# H21 — Atomic Plateaus & Rims

A self‑contained repo to reproduce the **passing** H21 simulation under your MATTER rules.

## What this does

- Runs a **present‑act**, boolean/ordinal engine (no RNG in control) with a deterministic DDA **1/r per shell**.
- Uses **diagnostics‑only** readouts to verify:
  1) **Radial plateaus** (low per‑band CV; muted gap), and  
  2) **Segmented rim** on the outer band (high K‑fold R² and visibility), while the inner band is azimuth‑flat.

## Quickstart

```bash
# 1) Python 3.10+ recommended. No external deps (stdlib only).
python3 --version

# 2) Run (creates a timestamped run under ./runs/)
python3 scripts/run_h21.py

# 3) Verify PASS and print metrics
python3 scripts/verify_h21.py   # auto-picks the latest run
```

### Expected PASS line (approximate numbers)
```
H21 PASS=True cv_inner=0.0000 cv_outer=0.0000 gap_ratio=0.000 seg_r2≈0.89 seg_vis=1.000 az_flat_inner≈0.02
```

## Repo layout

```
H21_atomic_rims/
  ├─ engine_h21_atomic_rims.py     # simulation engine (stdlib only)
  ├─ config/
  │   └─ manifest_h21.json         # PASSING aligned-bands manifest
  ├─ scripts/
  │   ├─ run_h21.py                # runs the engine and writes outputs
  │   └─ verify_h21.py             # checks acceptance gates & prints a summary
  ├─ runs/                         # created on first run (gitignored)
  ├─ .gitignore
  └─ README.md
```

## Acceptance gates (diagnostics only)

- `band_cv_max = 0.10`
- `gap_rel_max = 0.10`
- `seg_r2_min  = 0.80`
- `seg_vis_min = 0.20`
- `inner_az_flat_max = 0.03`

## Notes

- The **passing** geometry aligns band edges with the Δr binning so each band contains at least one full Δr bin.
- Control is never altered. Any tuning happens in **config/manifest_h21.json** (diagnostics geometry only).

## License

MIT (see `LICENSE`). © 2025 H21 Authors.
